<?php

namespace App\Http\Controllers\api\partneruser;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use App\Models\Fare;
use App\Models\Zone;
use App\Models\SearchHistory;
use App\Models\VehicleCategory;
use App\Models\BrandVehicle;
use App\Models\Vehicle;
use App\Models\Settings;
use App\Models\Review;
use App\Models\BookingHistory;
use Illuminate\Database\QueryException;
use Throwable;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class FareController extends Controller
{
    public function calculateFare(Request $request)
{
    try {
          $validator = Validator::make($request->all(), [
                        'origin' => 'required',
                        'destination' => 'required',
                        'vehicle_type' => 'required',
                        'waypoints' => 'required',
                         ]);
                
                         if ($validator->fails()) {
                            return response()->json([
                                'status' => false,
                                'message' => 'Validation errors',
                                'errors' => $validator->errors()
                            ], 422);
                         }
   
    $origin = $request->origin;
    $destination = $request->destination;
   $vehicleType = $request->vehicle_type;
    $waypoints = $request->waypoints ?? [];

    // Step 1: Get coordinates of origin
    $originCoords = $this->getCoordinatesFromAddress($origin);

    // Step 2: Find the zone for origin
    $zones = Zone::all();
    $originZone = null;
    foreach ($zones as $zone) {
        $polygon = $zone->coordinates; // should be parsed JSON
        if ($this->isPointInPolygon($originCoords, $polygon)) {
            $originZone = $zone;

            break;
        }
    }

    if (!$originZone) {
        return response()->json(['error' => 'Origin is outside service zones'], 422);
    }

    // Step 3: Get total distance
   $distance = $this->getTotalDistanceFromGoogle($origin, $destination, $waypoints);


    // Step 4: Calculate fare
    $fare =Fare::where('vehicle_type_id', $vehicleType)
        -> whereRaw('json_contains(city_id, \'["' . $originZone->id . '"]\')')
        ->first();

    // $fare = Fare::where('vehicle_type_id', $vehicleType)
    //     ->whereJsonContains('city_id', $originZone->id)
    //    ->first();
       // ->toSql();

        //  print_r($fare);die();

    if (!$fare) {
        return response()->json(['error' => 'No fare defined for this vehicle type and zone'], 404);
    }

    $baseKm = $fare->base_km;
    $baseRate = $fare->base_rate;
    $additionalKmRate = $fare->additional_km_rate;

    $totalFare = $baseRate;
   
    if ($distance > $baseKm) {
        $extraKm = $distance - $baseKm;
        $totalFare += $extraKm * $additionalKmRate;
    }

    return response()->json([
        'distance_km' => round($distance, 2),
        'fare' => round($totalFare, 2),
        'zone' => $originZone->name
    ]);

    } catch (QueryException $e) {
    return response()->json(['error' => 'Database error '.$e], 500);
} catch (Throwable $e) {
    return response()->json(['error' => 'Something went wrong '.$e], 500);
}
}

public function getTotalDistanceFromGoogle($origin, $destination, $waypoints = []) {
    try{
      $apiKey = Settings::pluck('google_map_api_key')->first() ;
      if(!empty($waypoints)){
      $waypoints = is_array($waypoints) ? $waypoints : explode('","', $waypoints ?? '');
      $waypointsStr = implode('|', $waypoints);  
        $response = Http::get("https://maps.googleapis.com/maps/api/directions/json", [
            'origin' => $origin,
            'destination' => $destination,
            'waypoints' => $waypointsStr,
            'key' => $apiKey,
        ]);
      }else{
         $response = Http::get("https://maps.googleapis.com/maps/api/directions/json", [
            'origin' => $origin,
            'destination' => $destination,
            'key' => $apiKey
         ]);
      }
        $data = $response->json();

        if (isset($data['routes'][0]['legs'])) {
        $totalDistance = 0;

        foreach ($data['routes'][0]['legs'] as $leg) {
            $totalDistance += $leg['distance']['value']; // in meters
        }

        $totalKm = $totalDistance / 1000;

        // find total return km
        $response = Http::get("https://maps.googleapis.com/maps/api/directions/json", [
        'origin' => $origin,
        'destination' => $destination,
        'key' => $apiKey
    ]);

    $data = $response->json();

    if ($data['status'] !== 'OK') {
        return response()->json(['error' => 'Unable to calculate distance', 'status' => $data['status']], 500);
    }

    $distanceInMeters = $data['routes'][0]['legs'][0]['distance']['value'];
    $distanceInKm = round($distanceInMeters / 1000, 2);

    $totalDistance=$totalKm+$distanceInKm;
    // echo $totalDistance.'='.$totalKm .'+'.$distanceInKm;
    // die();
        return $totalDistance;
      
    }

    return response()->json([
        'error' => 'Unable to calculate distance'
    ], 400);

    } catch (QueryException $e) {
    return response()->json(['error' => 'Database error '.$e], 500);
} catch (Throwable $e) {
    return response()->json(['error' => 'Something went wrong '.$e], 500);
}
}

public function isPointInPolygon($point, $polygon)
{
    try{
    $lat = $point['lat'];
    $lng = $point['lng'];
    $inside = false;
    $j = count($polygon) - 1;

    for ($i = 0; $i < count($polygon); $i++) {
        $xi = $polygon[$i]['lat'];
        $yi = $polygon[$i]['lng'];
        $xj = $polygon[$j]['lat'];
        $yj = $polygon[$j]['lng'];

        $intersect = (($yi > $lng) != ($yj > $lng))
            && ($lat < ($xj - $xi) * ($lng - $yi) / ($yj - $yi) + $xi);
        if ($intersect) $inside = !$inside;
        $j = $i;
    }

    return $inside;
    } catch (QueryException $e) {
    return response()->json(['error' => 'Database error '.$e], 500);
} catch (Throwable $e) {
    return response()->json(['error' => 'Something went wrong '.$e], 500);
}
}

public function getCoordinatesFromAddress($address) {
    try{
    $apiKey = Settings::pluck('google_map_api_key')->first() ;
    $response = Http::get("https://maps.googleapis.com/maps/api/geocode/json", [
        'address' => $address,
        'key' => $apiKey,
    ]);

    $data = $response->json();
    if ($data['status'] === 'OK') {
        $location = $data['results'][0]['geometry']['location'];
        return ['lat' => $location['lat'], 'lng' => $location['lng']];
    }

    throw new \Exception("Invalid address or failed to fetch coordinates.");
    } catch (QueryException $e) {
    return response()->json(['error' => 'Database error '.$e], 500);
} catch (Throwable $e) {
    return response()->json(['error' => 'Something went wrong '.$e], 500);
}
}

    public function chooseRide(Request $request)
    {
                try {
                      $validator = Validator::make($request->all(), [
                         'origin' => 'required',
                         'destination' => 'required',
                         ]);
                
                         if ($validator->fails()) {
                            return response()->json([
                                'status' => false,
                                'message' => 'Validation errors',
                                'errors' => $validator->errors()
                            ], 422);
                         }
               
            $setting=Settings::first();

            //     SearchHistory::insert([
            //         'user_id'=>auth()->user()->id,
            //         'departure_date'=>date("Y-m-d",strtotime($request->departure_date)),
            //         'return_date'=>date("Y-m-d",strtotime($request->return_date)),
            //         'departure_time'=>$request->departure_time,
            //         'return_time'=>$request->return_time,
            //         'pick_up'=>$request->origin,
            //         'drop_off'=>$request->destination,
            //         'stay_date'=>json_encode($request->stay_date),
            //         'stay_locations'=> json_encode($request->stay_locations),
            //         'adults'=>$request->adults,
            //         'children'=>$request->children,
            //         'client_name'=>$request->client_name,
            //         'client_mobile_number'=>$request->client_mobile_number,
            //         'client_email'=>$request->client_email,
            //     ]);

                    $serachhistory = new SearchHistory();
                    $serachhistory->user_id=auth()->user()->id;
                    $serachhistory->departure_date=date("Y-m-d",strtotime($request->departure_date));
                    $serachhistory->return_date=date("Y-m-d",strtotime($request->return_date));
                    $serachhistory->departure_time=$request->departure_time;
                    $serachhistory->return_time=$request->return_time;
                    $serachhistory->pick_up=$request->origin;
                    $serachhistory->drop_off=$request->destination;
                    $serachhistory->stay_date=json_encode($request->stay_date);
                    $serachhistory->stay_locations= json_encode($request->waypoints);
                    $serachhistory->adults=$request->adults;
                    $serachhistory->children=$request->children;
                    $serachhistory->client_name=$request->client_name;
                    $serachhistory->client_mobile_number=$request->client_mobile_number;
                    $serachhistory->client_email=$request->client_email;
                    $serachhistory->save();

                $origin = $request->origin;
                $destination = $request->destination;
                $waypoints = $request->waypoints ?? [];

                // Step 1: Get coordinates of origin
                $originCoords = $this->getCoordinatesFromAddress($origin);

                // Step 2: Find the zone for origin
                $zones = Zone::all();
                $originZone = null;
                foreach ($zones as $zone) {
                    $polygon = $zone->coordinates; // should be parsed JSON
                    if ($this->isPointInPolygon($originCoords, $polygon)) {
                        $originZone = $zone;

                        break;
                    }
                }

                if (!$originZone) {
                    return response()->json(['error' => 'Origin is outside service zones'], 422);
                }

                  $additional_km_in_table=$setting->additional_km;

                  if ($request->filled('waypoints')) {
                $json = $request->waypoints;
                $locations = json_decode($json, true); // convert to PHP array

                $count = count($locations);
              
                // Step 3: Get total distance
                     $distance = $this->getTotalDistanceFromGoogle($origin, $destination, $waypoints)+($count*$additional_km_in_table);
                  }else{
                    $waypoints=[];
                    $distance = $this->getTotalDistanceFromGoogle($origin, $destination, $waypoints)+$additional_km_in_table;
                  }
            $vehicleType= VehicleCategory::where('status','Active')->get()->makeHidden(['status','created_at', 'updated_at']);

      foreach($vehicleType  as $k=>$item){
                // Step 4: Calculate fare
                $item->gallery_images=[];
                $fare =Fare::where('vehicle_type_id', $item->id)
                    -> whereRaw('json_contains(city_id, \'["' . $originZone->id . '"]\')')
                    ->first();


                $item->image=asset("uploads/category/" . $item->image);
                $item->seats=BrandVehicle::where('vehicle_type',$item->id)->pluck('max_passengers')->first();
                $item->model_list= BrandVehicle::where('vehicle_type',$item->id)->pluck('model_name')->implode(', ');

            // 3 images
                $images=[];
                $brands = Vehicle::where('vehicle_type',$item->id)->get();

            $gallery_images=[];
                if(count($brands)>0){
                foreach ($brands as $brand) {
                    if($brand->image!=NULL){
                        foreach (json_decode($brand->image) as $i=>$img) {
                            if ($i == 3) {
                                    break ; // Stop looping once 3 images collected
                                }
                            $gallery_images[$i] = asset('uploads/vehicle/' .$img); // or Storage::url($img) if using storage

                            
                        
                        }
                    }
                }
                }
            $item->gallery_images=$gallery_images;
                if (!$fare) {                  
                      $item->fare=round(0, 2);
                      $item->tax_amount=0;
                      $item->total_rate=0;
                      $item->platform_fee=0 ;
                    continue;
                // return response()->json(['error' => 'No fare defined for this vehicle type and zone'], 404);
                }

                $offerStartDate = $fare->offer_start_date;
                $offerEndDate = $fare->offer_end_date;
                $bookingDate = date("Y-m-d",strtotime($request->departure_date));
                $discountPercentage = 20;

                $surchargeStartDate = $fare->surcharge_start_date;
                $surchargeEndDate = $fare->surcharge_end_date;
                $surchargePercentage = 10;

                $baseKm = $fare->base_km;
                $baseRate = $fare->base_rate;
                if ($bookingDate >= $offerStartDate && $bookingDate <= $offerEndDate) {
                    // Apply discount
                    $discountAmount = $baseRate * ($discountPercentage / 100);
                    $offerPrice = $baseRate - $discountAmount;
                    $baseRate = round($offerPrice, 2);            
                }


                if ($bookingDate >= $surchargeStartDate && $bookingDate <= $surchargeEndDate) {
                    // Apply discount
                    $discountAmount = $baseRate * ($surchargePercentage / 100);
                    $surchargePrice = $baseRate + $discountAmount;
                    $baseRate = round($surchargePrice, 2);            
                }
                // if(auth()->user()->role=='Partner'){
                //     $baseRate = $fare->base_rate*(auth()->user()->platform_fee/100);
                // }else{
                
              //  }
           
                $additionalKmRate = $fare->additional_km_rate;

                $totalFare = $baseRate;
            
                if ($distance > $baseKm) {
                    $extraKm = $distance - $baseKm;
                    $totalFare += $extraKm * $additionalKmRate;
                }

            $tax = ($setting->tax / 100) * $totalFare ;
            $item->fare=round($totalFare, 2);
            $item->tax_amount=round($tax, 2);
            $item->total_rate= $item->fare+$item->tax_amount;
            $item->platform_fee= ($setting->platform_fee/100) * $item->total_rate;
            }
                return response()->json([
                    'status'=>true,
                    'total_distance_in_km' => round($distance, 2),
                    'serachhistory_id'=>$serachhistory->id,
                    'cabs' => $vehicleType,
                   
                ]);

                    } catch (QueryException $e) {
                    return response()->json(['error' => 'Database error '.$e], 500);
                    } catch (Throwable $e) {
                        return response()->json(['error' => 'Something went wrong '.$e], 500);
                    }
    }

  public function chooseCar(Request $request)
  {
                try {
                      $validator = Validator::make($request->all(), [
                       'origin' => 'required',
                       'vehicle_type' => 'required',
                         ]);
                
                $origin = $request->origin;
               

                // Step 1: Get coordinates of origin
                $originCoords = $this->getCoordinatesFromAddress($origin);

                // Step 2: Find the zone for origin
                $zones = Zone::all();
                $originZone = null;
                foreach ($zones as $zone) {
                    $polygon = $zone->coordinates; // should be parsed JSON
                    if ($this->isPointInPolygon($originCoords, $polygon)) {
                        $originZone = $zone;

                        break;
                    }
                }

                if (!$originZone) {
                    return response()->json(['error' => 'Origin is outside service zones'], 422);
                }

               
            // 3 images
                $images=[];
              
    $vehicles = Vehicle::join('drivers', 'vehicles.driver_id', '=', 'drivers.id')
    ->join('vendors', 'vehicles.vendor_id', '=', 'vendors.id')
    ->leftJoin('reviews', 'vehicles.id', '=', 'reviews.vehicle_id')
    ->leftJoin('booking_histories', 'vehicles.id', '=', 'booking_histories.vehicle_id')
    ->select(
        'vehicles.id',
        'vehicles.seats',
        'vehicles.fuel_type',
        'vehicles.model',
        'vehicles.vehicle_make',
        'vehicles.image',
        'vendors.name as vendor_name',
        'vendors.vendor_image',
        DB::raw('AVG(reviews.overall_rating) as avg_rating'),
        DB::raw('COUNT(booking_histories.id) as total_trips')
    )
    ->where('vehicles.vehicle_type', $request->vehicle_type)
    ->where('drivers.zone', '=', $originZone->id)
    ->groupBy(
        'vehicles.id',
        'vehicles.seats',
        'vehicles.fuel_type',
        'vehicles.model',
        'vehicles.vehicle_make',
        'vehicles.image',
        'vendors.name',
        'vendors.vendor_image'
    );
   // ->having('avg_rating', '>=', $request->filter_rate) // Optional: filter by minimum rating
 //   ->get();
    if ($request->filled('filter_rate')) {
                                           $vehicles= $vehicles->where('avg_rating', $request->filter_rate);
                                        }
                                      if ($request->filled('filter_cab_model')) {
                                           $vehicles= $vehicles->where('vehicle_make', $request->filter_cab_model);
                                        }

                                        $vehicles = $vehicles->get();
            $gallery_images=[];
                if(count($vehicles)>0){
                foreach ($vehicles as $vehicle) {
                    if($vehicle->image!=NULL){
                        $vehicle->model=BrandVehicle::where('id',$vehicle->model)->pluck('model_name')->first();
                        foreach (json_decode($vehicle->image) as $i=>$img) {
                            if ($i == 3) {
                                    break ; // Stop looping once 3 images collected
                                }
                            $gallery_images[$i] = asset('uploads/vehicle/' .$img); // or Storage::url($img) if using storage

                            
                        
                        }
                    }
                   if($vehicle->vendor_image==NULL){
                    $vehicle->vendor_image=asset('assets/images/user.jpg');
                   }else{
                     $vehicle->vendor_image=asset('uploads/vendor/' .$vehicle->vendor_image);
                   }
                    $vehicle->image=$gallery_images;
                }
                }
            
              
                return response()->json([
                    'status'=>true,
                    'cars' => $vehicles,
                ]);

            } catch (QueryException $e) {
                    return response()->json(['error' => 'Database error '.$e], 500);
                    } catch (Throwable $e) {
                        return response()->json(['error' => 'Something went wrong '.$e], 500);
                    }
    }


    public function addCommission(Request $request)
    {
                try {
                       $validator = Validator::make($request->all(), [
                        'commission' => 'required',
                         'total_fare' => 'required',
                         'tax'=>'required',
                         ]);
                
                         if ($validator->fails()) {
                            return response()->json([
                                'status' => false,
                                'message' => 'Validation errors',
                                'errors' => $validator->errors()
                            ], 422);
                         }

                     
                     $setting=Settings::first();
                    $commission_rate =  ($request->commission / 100) * $request->total_fare ;
                    $total_fare =$request->total_fare + $commission_rate + $request->tax;
                    $platform_fee= ($setting->platform_fee/100) * $total_fare;
                     return response()->json([
                        'status'=>true,
                        'commission_rate' => round($commission_rate,2),
                        'total_fare' => round($total_fare,2),
                        'platform_fee'=>round($platform_fee,2)
                ]);
                     } catch (QueryException $e) {
                    return response()->json(['error' => 'Database error '.$e], 500);
                    } catch (Throwable $e) {
                        return response()->json(['error' => 'Something went wrong '.$e], 500);
                    }
                }

           public function bookCab(Request $request)
             {
                try{
                $bookingHistory=SearchHistory::where('id',$request->serachhistory_id)->first();
                

                $latest = BookingHistory::latest()->first();
                $number = $latest ? intval(substr($latest->booking_id, 2)) + 1 : 1;
                $bookingid='BK' . str_pad($number, 6, '0', STR_PAD_LEFT);
                
           $vehicle=Vehicle::where('id',$request->vehicle_id)->first();

                $res=BookingHistory::insert([               
                    'booking_id'=>$bookingid,
                    'vendor_id'=> $vehicle->vendor_id ,
                    'vehicle_id'=> $request->vehicle_id ,
                    //'driver_id'=> $vehicle->driver_id ,
                    'booked_user_id'=>auth()->user()->id,
                    'role'=>auth()->user()->role,
                    'total_km'=> $request->total_km ,
                    'departure_date'=>$bookingHistory->departure_date,
                    'return_date'=>$bookingHistory->return_date,
                    'departure_time'=>$bookingHistory->departure_time,
                    'return_time'=>$bookingHistory->return_time,
                    'pick_up'=>$bookingHistory->pick_up,
                    'drop_off'=>$bookingHistory->drop_off,
                    'stay_date'=>$bookingHistory->stay_date,
                    'stay_locations'=> $bookingHistory->stay_locations,
                    'adults'=>$bookingHistory->adults,
                    'children'=>$bookingHistory->children,
                    'client_name'=>$bookingHistory->client_name,
                    'client_mobile_number'=>$bookingHistory->client_mobile_number,
                    'client_email'=>$bookingHistory->client_email,
                    'commission_rate'=> $request->commission_rate ,
                    'tax'=> $request->tax ,
                    'total_fare'=> $request->total_fare ,
                    'platform_fee'=> $request->platform_fee ,
                    'paid_amount'=> $request->paid_amount ,
                ]);
                    if($res==1){
                        return response()->json([
                        'status'=>true,
                        'message' => 'Ride booked successfully!',
                ]); 
                    }
                   } catch (QueryException $e) {
                    return response()->json(['error' => 'Database error '.$e], 500);
                    } catch (Throwable $e) {
                        return response()->json(['error' => 'Something went wrong '.$e], 500);
                    }
                
            }


            public function getBookings(Request $request)
             {
                try{
                
                    $bookings= BookingHistory::select('id','booking_id','departure_date','return_date','departure_time','return_time','pick_up','drop_off','stay_locations','booking_status','total_fare','paid_amount')->get();
                    foreach($bookings as $item){
                        $raw = $item->stay_locations; // The double-encoded JSON string

                        $firstDecode = json_decode($raw, true);              // returns a JSON string
                        $locationsArray = json_decode($firstDecode, true);   // returns the actual PHP array

                        $locationString = is_array($locationsArray) ? implode(', ', $locationsArray) : '';

                        $item->stay_locations= $locationString;
                      //  $item->stay_locations_count = is_array($locationsArray) ? count($locationsArray) : 0;

                        $departure = Carbon::parse($item->departure_date);
                        $return = Carbon::parse($item->return_date);

                        // Total days (inclusive)
                        $totalDays = $departure->diffInDays($return) + 1; // +1 to include both start and end dates
                        $nightCount = $totalDays - 1;

                        // Final title
                        $tripTitle = "{$nightCount}NIGHTS {$totalDays}DAYS";
                        $item->title=$tripTitle;
                    }
                 
                      return response()->json([
                            'status'=>true,
                            'bookings' => $bookings,
                     ]); 
                        
                   } catch (QueryException $e) {
                        return response()->json(['error' => 'Database error '.$e], 500);
                    } catch (Throwable $e) {
                        return response()->json(['error' => 'Something went wrong '.$e], 500);
                    }
                
            }

   public function getBookingDetails(Request $request)
             {
                try{
             
                    // $booking= BookingHistory::select('id','vehicle_id','driver_id','booking_id','total_km','departure_date','return_date','departure_time','return_time','pick_up','drop_off','stay_date','stay_locations','adults','children','client_name','client_mobile_number','client_email','booking_status','total_fare','paid_amount','overall_review_rate')
                    // ->where('id',$request->booking_id)
                    // ->first();

                    $booking=  BookingHistory::select(
                                'booking_histories.*',
                                'reviews.driver_rating',
                                'reviews.car_rating',
                                'reviews.comment'
                            )
                            ->leftJoin('reviews', 'booking_histories.id', '=', 'reviews.booking_id')
                            ->where('booking_histories.id',$request->booking_id)
                            ->first();
                             $booking->makeHidden(['created_at', 'updated_at']);
                   // ********** stay location  *********
                        $raw = $booking->stay_locations; // The double-encoded JSON string
                        $firstDecode = json_decode($raw, true);              // returns a JSON string
                        $locationsArray = json_decode($firstDecode, true);   // returns the actual PHP array
                        $booking->stay_locations= $locationsArray;
                      // ********** stay date end  *********

                      // ********** find titile  *********
                        $departure = Carbon::parse($booking->departure_date);
                        $return = Carbon::parse($booking->return_date);

                        // Total days (inclusive)
                        $totalDays = $departure->diffInDays($return) + 1; // +1 to include both start and end dates
                        $nightCount = $totalDays - 1;

                        // Final title
                        $tripTitle = "{$nightCount}NIGHTS {$totalDays}DAYS";
                        $booking->title=$tripTitle;
                 // ********** find titile end  *********
                 
                 // ********** stay date  *********
                        $raw = $booking->stay_date; // The double-encoded JSON string

                        $firstDecode = json_decode($raw, true);              // returns a JSON string
                        $locationsArray = json_decode($firstDecode, true);   // returns the actual PHP array

                        $booking->stay_date= $locationsArray;
                    // ********** stay date end *********
                             $vehicle = Vehicle::join('drivers', 'vehicles.driver_id', '=', 'drivers.id')
                                    ->join('vendors', 'vehicles.vendor_id', '=', 'vendors.id')
                                    ->leftJoin('reviews', 'vehicles.id', '=', 'reviews.vehicle_id')
                                    ->leftJoin('booking_histories', 'vehicles.id', '=', 'booking_histories.vehicle_id')
                                    ->select(
                                        'vehicles.id',
                                        'vehicles.seats',
                                        'vehicles.fuel_type',
                                        'vehicles.model',
                                        'vehicles.vehicle_make',
                                        'vehicles.image',
                                        'vendors.name as vendor_name',
                                        'vendors.vendor_image',
                                        DB::raw('AVG(reviews.overall_rating) as avg_rating'),
                                        DB::raw('COUNT(booking_histories.id) as total_trips')
                                    )
                                ->where('vehicles.id',$booking->vehicle_id)
                                    ->groupBy(
                                        'vehicles.id',
                                        'vehicles.seats',
                                        'vehicles.fuel_type',
                                        'vehicles.model',
                                        'vehicles.vehicle_make',
                                        'vehicles.image',
                                        'vendors.name',
                                        'vendors.vendor_image'
                                    )
                            ->first();
                    // $vehicle =  Vehicle::join('vendors', 'vehicles.vendor_id', '=', 'vendors.id')
                    //                ->join('drivers', 'drivers.vendor_id', '=', 'vendors.id')
                    //                 ->select('vehicles.id','vehicles.seats','vehicles.fuel_type','vehicles.model','vehicles.vehicle_make','vehicles.image', 'vendors.name as vendor_name','vendors.vendor_image') // select vendor fields as needed
                    //                 ->where('vehicles.id',$booking->vehicle_id)
                    //                 ->first();

                   $vehicle->model=BrandVehicle::where('id',$vehicle->model)->pluck('model_name')->first();
                        foreach (json_decode($vehicle->image) as $i=>$img) {
                            if ($i == 3) {
                                    break ; // Stop looping once 3 images collected
                                }
                            $gallery_images[$i] = asset('uploads/vehicle/' .$img); // or Storage::url($img) if using storage
                            }
                    
                   if($vehicle->vendor_image==NULL){
                    $vehicle->vendor_image=asset('assets/images/user.jpg');
                   }else{
                     $vehicle->vendor_image=asset('uploads/vendor/' .$vehicle->vendor_image);
                   }
                    $vehicle->image=$gallery_images;
                    $vehicle->review_rate=5;
                   
                
                    $booking->cab_agency_details=$vehicle;
                      return response()->json([
                            'status'=>true,
                            'booking_details' => $booking,
                     ]); 
                        
                   } catch (QueryException $e) {
                        return response()->json(['error' => 'Database error '.$e], 500);
                    } catch (Throwable $e) {
                        return response()->json(['error' => 'Something went wrong '.$e], 500);
                    }
                
            }


               public function addReview(Request $request)
             {
                try{
                    $exist=Review::where('booking_id',$request->booking_id)->first();
                    if($exist==null){
                            $res=Review::insert([
                                'booking_id'=>$request->booking_id ,
                                'user_id'=>auth()->user()->id ,
                                'vehicle_id'=>$request->vehicle_id ,
                                'driver_id'=>$request->driver_id ,
                                'overall_rating'=>$request->overall_rating ,
                                'driver_rating'=>$request->driver_rating ,
                                'car_rating'=>$request->car_rating ,
                                'comment'=>$request->comment ,
                            ]);
                        }else{
                            $res=Review::where('id',$exist->id)->update([
                                'booking_id'=>$request->booking_id ,
                                'user_id'=>auth()->user()->id ,
                                'vehicle_id'=>$request->vehicle_id ,
                                'driver_id'=>$request->driver_id ,
                                'overall_rating'=>$request->overall_rating ,
                                'driver_rating'=>$request->driver_rating ,
                                'car_rating'=>$request->car_rating ,
                                'comment'=>$request->comment ,
                            ]);
                        }
                            BookingHistory::where('id',$request->booking_id)->update(['overall_review_rate'=>$request->overall_rating]);
                            if($res==1){
                            return response()->json([
                                'status'=>true,
                                'message' => "Review added Successfully",
                            ]); 
                        
                            }
                     } catch (QueryException $e) {
                        return response()->json(['error' => 'Database error '.$e], 500);
                    } catch (Throwable $e) {
                        return response()->json(['error' => 'Something went wrong '.$e], 500);
                    }
                
            }

             public function getAgencyDetails(Request $request)
             {
                try{
                         $vehicle =  Vehicle::join('vendors', 'vehicles.vendor_id', '=', 'vendors.id')
                                   ->join('drivers', 'drivers.vendor_id', '=', 'vendors.id')
                                    ->select('vehicles.id',
                                       'vehicles.model',
                                        'vehicles.vehicle_make' ,
                                        'vehicles.year_of_registration' ,
                                        'vehicles.seats' ,
                                        'vehicles.color',
                                        'vehicles.fuel_type',
                                        'vehicles.plate_number',
                                        'vehicles.reg_validity',
                                        'vehicles.insurance_validity' ,
                                        'vehicles.tax_validity' ,
                                        'vehicles.image', 
                                        'vehicles.vehicle_type',
                                        'vendors.name as vendor_name',
                                        'vendors.vendor_image') // select vendor fields as needed
                                    ->where('vehicles.id',$request->vehicle_id)
                                    ->first();
                         $vehicle->model=BrandVehicle::where('id',$vehicle->model)->pluck('model_name')->first();
                        foreach (json_decode($vehicle->image) as $i=>$img) {
                            if ($i == 3) {
                                    break ; // Stop looping once 3 images collected
                                }
                            $gallery_images[$i] = asset('uploads/vehicle/' .$img); // or Storage::url($img) if using storage
                            }
                    
                   if($vehicle->vendor_image==NULL){
                    $vehicle->vendor_image=asset('assets/images/user.jpg');
                   }else{
                     $vehicle->vendor_image=asset('uploads/vendor/' .$vehicle->vendor_image);
                   }
                    $vehicle->image=$gallery_images;
                  //  $vehicle->reviews=Review::where('vehicle_id',$request->vehicle_id)->get(); 
                  $vehicle->reviews=  Review::select('reviews.id as reviewid','partners.name as user_name','partners.image as user_image','reviews.overall_rating','reviews.driver_rating','reviews.car_rating','reviews.comment','reviews.created_at')
                                    ->join('partners', 'partners.id', '=', 'reviews.user_id')
                                     ->where('reviews.vehicle_id',$request->vehicle_id)
                                    ->orderBy('reviews.id', 'desc')
                                    ->get();
                    foreach($vehicle->reviews as $item){
                       
                                if($item->image==NULL){
                                        $item->image=asset('assets/images/user.jpg');
                                    }else{
                                        $item->image=asset('uploads/partner/' .$item->image);
                                    }
                    }
                    $vehicle->vehicle_type=VehicleCategory::where('id',$vehicle->vehicle_type)->pluck('name')->first();

                    //** rating **** */

                  $perStarAverage = Review::select(
                                    'overall_rating',
                                    DB::raw('ROUND(AVG(overall_rating), 1) as average'),
                                    DB::raw('COUNT(*) as count')
                                )
                                ->whereIn('overall_rating', [1, 2, 3, 4, 5])
                                ->where('vehicle_id', $request->vehicle_id)
                                ->groupBy('overall_rating')
                                ->orderBy('overall_rating', 'desc')
                                ->get();
                    
                    $vehicle->total_review_rate = $perStarAverage;
                    
                    // Initialize all ratings from 0 to 5 with default values
                    $ratings = [];
                    for ($i = 0; $i <= 5; $i++) {
                        $ratings[$i] = [
                            'rate'=>$i,
                            'average' => 0.0,
                            'count' => 0,
                        ];
                    }
                    
                    // Overwrite with actual data from DB
                    foreach ($perStarAverage as $row) {
                        $ratings[$row->overall_rating] = [
                             'rate'=>$row->overall_rating,
                            'average' => (float) $row->average,
                            'count' => (int) $row->count,
                        ];
                    }

                  //  $perStarAverage->review_details=$ratings;
                    $vehicle->review_star_rate=$ratings;
                     return response()->json([
                            'status'=>true,
                            'vehicle' => $vehicle,
                     ]); 

                 } catch (QueryException $e) {
                        return response()->json(['error' => 'Database error '.$e], 500);
                    } catch (Throwable $e) {
                        return response()->json(['error' => 'Something went wrong '.$e], 500);
                    }
                
            }

               public function getVehicleModels(Request $request)
             {
                try{
              
                $models = Vehicle::distinct()->where('status', 'ACTIVE')->pluck('vehicle_make');


                return response()->json([
                    'status'=>true,
                    'models' => $models,
                ]);

            } catch (QueryException $e) {
                    return response()->json(['error' => 'Database error '.$e], 500);
                    } catch (Throwable $e) {
                        return response()->json(['error' => 'Something went wrong '.$e], 500);
                    }               
       }

}